﻿<%@ Page Language="c#" CodePage="1200" autoeventwireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.EwidencjaVat" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja VAT</title>
		<META http-equiv="Content-Type" content="text/html; charset=unicode">
		<script runat="server">

    void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
      INaglowekVAT nag = (INaglowekVAT)args.Row;
    
      colNumer.EditValue              = nag.Numer;
      colNumerDokumentu.EditValue     = nag.NumerDokumentu;
      colDataDokumentu.EditValue      = nag.DataDokumentu;
      colDefinicja.EditValue          = nag.Definicja;
    
    
      podsumowanie.Naglowek = nag;
      Podsumowanie.PodsumowanieStawekVATItem item = null;
    
      item = podsumowanie.PodsumowanieStawekVAT[ZW];
      if(item!=null)
        colNettoZw.EditValue  = item.Netto.Value;
      else
        colNettoZw.EditValue  = 0m;
    
      item = podsumowanie.PodsumowanieStawekVAT[NP];
      if(item!=null)
        colNettoZw.EditValue  = (decimal)colNettoZw.EditValue + item.Netto.Value;
    
      item = podsumowanie.PodsumowanieStawekVAT[Op0];
      if(item!=null)
        colNetto0.EditValue   = item.Netto.Value;
      else
        colNetto0.EditValue   = 0m;
    
      item = podsumowanie.PodsumowanieStawekVAT[Op3];
      if(item!=null){
        colNetto3.EditValue   = item.Netto.Value;
        colVAT3.EditValue     = item.VAT.Value;
      }
      else{
        colNetto3.EditValue    = 0m;
        colVAT3.EditValue      = 0m;
      }
    
      item = podsumowanie.PodsumowanieStawekVAT[Op7];
      if(item!=null){
        colNetto7.EditValue   = item.Netto.Value;
        colVAT7.EditValue     = item.VAT.Value;
      }
      else{
        colNetto7.EditValue   = 0m;
        colVAT7.EditValue     = 0m;
      }
    
      item = podsumowanie.PodsumowanieStawekVAT[Op12];
      if(item!=null){
        colNetto12.EditValue  = item.Netto.Value;
        colVAT12.EditValue    = item.VAT.Value;
      }
      else{
        colNetto12.EditValue  = 0m;
        colVAT12.EditValue    = 0m;
      }
    
      item = podsumowanie.PodsumowanieStawekVAT[Op22];
      if(item!=null){
        colNetto22.EditValue  = item.Netto.Value;
        colVAT22.EditValue    = item.VAT.Value;
      }
      else{
        colNetto22.EditValue  = 0m;
        colVAT22.EditValue    = 0m;
      }
    
      DaneKontrahenta danePodmiotu = ((PodmiotEwidencja)nag.Ewidencja).DaneKontrahenta;
    
      string kod = nag.Podmiot.Kod;
      if(danePodmiotu.EuVAT!="")
        kod += string.Format(" ({0})",danePodmiotu.EuVAT);
      colKod.EditValue      = kod;
      //colNIP.EditValue      = danePodmiotu.NIP;
      colNazwa.EditValue    = string.Format("{0} {1}",danePodmiotu.Nazwa,danePodmiotu.Adres);
    
      colNetto.EditValue  = nag.Netto.Value;
      colVAT.EditValue    = nag.VAT.Value;
      colBrutto.EditValue = nag.Brutto.Value;
    
    }
    
    Podsumowanie podsumowanie = null;
    DefinicjaStawkiVat NP = null, ZW = null, Op22 = null, Op12 = null, Op7 = null, Op3 = null, Op0 = null;
    
    void EwidencjaVAT_OnLoad(Object sender, EventArgs args){
      podsumowanie                  = new Podsumowanie();
      NagEwidencjiVATT.Params p     = null;
      if(DataContext1.Context.Contains(typeof(NagEwidencjiVATT.Params)))
                     p = (NagEwidencjiVATT.Params)DataContext1.Get(typeof(NagEwidencjiVATT.Params));
      if(p==null){
                     p = new NagEwidencjiVATT.Params(DataContext1.Context,true);
                     p.Typ = TypEwidencjiVAT.Sprzedaż;
                     if (DataContext1.Context.Contains(typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)))
                        p.Zakres = ((Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
                            DataContext1.Get(typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams))).Okres;
                     else
                        p.Zakres = ((OkresContext)DataContext1.Get(typeof(OkresContext))).Okres;
                     //TODO: ustawić date
                     /*Row[] rows = (Row[])DataContext1[typeof(Row[])];
                     ArrayList arr = new ArrayList();
                     foreach(DokumentHandlowy dok in rows){
                         if(dok.Ewidencja!=null){
                             NagEwidencjiVAT nag = ((VATEwidencja)dok.Ewidencja).NagEwidencjiVAT;
                             if(nag!=null)
                                 arr.Add(nag);
                         }
                     }
                     Grid1.DataSource = arr;*/
                     Grid1.DataSource = new SubTable(EwidencjaVatModule.GetInstance(DataContext1.Session).NagEwidencjiVATT.WgTyp[p.Typ],p.Zakres);
      }
    
      string tytul = "";
      if(p is NagRozliczenVATT.Params){
        colData.Caption     = "Data roz.";
        colData.DataMember  = "Data";
        tytul = "Rozliczenia VAT";
      }
      else{
        colData.DataMember = "DataZaewidencjonowania";
        tytul = "Ewidencja VAT";
      }
    
      ReportHeader1.Title =
        string.Format(ReportHeader1.Title,
        tytul, p.Typ, p.Zakres, p.Definicja==null ? "Wszystkie" : p.Definicja.ToString(),
        p.Podmiot==null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty);
    
      if(p.Porownanie!=TypPorownania.Brak)
        ReportHeader1.Title =
          string.Format("{0} | Kwota brutto {1} {2:n}",
            ReportHeader1.Title,CaptionAttribute.EnumToString(p.Porownanie),p.Kwota);
    
      DefStawekVat definicjeStawek  = CoreModule.GetInstance(DataContext1.Session).DefStawekVat;
    
      NP    = definicjeStawek[DefinicjaStawkiVat.NP];
      ZW    = definicjeStawek[DefinicjaStawkiVat.ZW];
      Op22  = definicjeStawek[DefinicjaStawkiVat.Op22];
      Op12  = definicjeStawek[DefinicjaStawkiVat.Op12];
      Op7   = definicjeStawek[DefinicjaStawkiVat.Op7];
      Op3   = definicjeStawek[DefinicjaStawkiVat.Op3];
      Op0   = definicjeStawek[DefinicjaStawkiVat.Op0];
    
    }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="EwidencjaVAT" method="post" onload="EwidencjaVAT_OnLoad" runat="server">
			<ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"></ea:DataContext>
			<br>
			<cc1:ReportHeader id="ReportHeader1" title="{0} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, Podmiot: {4}, Korekty: {5}"
				runat="server"></cc1:ReportHeader>
			<br>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowsInRow="3" RowTypeName="Soneta.EwidencjaVat.NagEwidencjiVAT,Soneta.Ksiega">
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="colLp" RowSpan="3"></ea:GridColumn>
					<ea:GridColumn Caption="Nr ewid." ID="colNumer"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Nr dok." ID="colNumerDokumentu"></ea:GridColumn>
					<ea:GridColumn ColSpan="9" Caption="Podmiot (Nazwa + Adres)" ID="colNazwa"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" Caption="Data zaew." ID="colData"></ea:GridColumn>
					<ea:GridColumn ColSpan="3" Align="Center" Caption="Podmiot (Kod + NIP)" ID="colKod"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" Caption="Data dok." ID="colDataDokumentu"></ea:GridColumn>
					<ea:GridColumn Width="8" Align="Center" Caption="Definicja" ID="colDefinicja"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Wart. zw." Format="{0:n}" ID="colNettoZw"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Wart. 0%" Format="{0:n}" ID="colNetto0"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Netto 3%" Format="{0:n}" ID="colNetto3"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="VAT 3%" Format="{0:n}" ID="colVAT3"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Netto 7%" Format="{0:n}" ID="colNetto7"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="VAT 7%" Format="{0:n}" ID="colVAT7"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Netto 12%" Format="{0:n}" ID="colNetto12"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="VAT 12%" Format="{0:n}" ID="colVAT12"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Netto 22%" Format="{0:n}" ID="colNetto22"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="VAT 22%" Format="{0:n}" ID="colVAT22"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Netto" Format="{0:n}" ID="colNetto"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="VAT" Format="{0:n}" ID="colVAT"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Brutto" Format="{0:n}" ID="colBrutto"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<br>
			<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

